#version 330

uniform mat4 view;
uniform mat4 invview;
uniform mat4 proj;
uniform float time;

in vec4 vertex;
in vec4 uv0;

out vec4 uv;
out vec3 norm;

void main() 
{
	vec4 clipPos;
	clipPos.xyz = mat3(view) * vertex.xyz; 
	clipPos = proj * vec4(clipPos.xyz, 1); 
	
	uv.xy = uv0.xy;
	norm = normalize(vertex.xyz); 
	//uv.zw = vec2(4.7459, 2.0103)*time + invview._m03_m13*0.0005;
	uv.zw = vec2(4.7459, 2.0103)*time + vec2(invview[3][0], invview[3][1]).xy*0.0005;
	gl_Position = clipPos;
}
